#ifndef __COMMAND_H__
#define __COMMAND_H__

#ifdef __cplusplus
extern "C" {
#endif

unsigned char PackageReceive(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);
unsigned char PackageTransmit(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);

Bool GetCurrent(U8 index,U8 *Value);

Bool SetCurrent(U8 index,U8 Value);
Bool LedOnOff(U8 index,unsigned char flag);

Bool Flip(unsigned char FlipX,unsigned char FlipY);
unsigned char  GetProductID(unsigned char *pID);
unsigned char PowerOnOff(unsigned char flag);
Bool GetLedDefaultStatus(U8 *flag);
Bool SetLedDefaultStatus(U8 flag);
Bool ShakeHands(U8 dwPort,U32 dwBaudRate);
Bool GetTemperature(S16 *Temperature);
Bool GetUseTime(U32 *UseTime);
Bool LedTest(U8 *Result);
Bool GetUvValue(U16 *Value);
Bool SetUvPower(U16 Value);//λmW
Bool GetUvPower(U16 *Value);//λmW
Bool SetUvAuto(U8 flag);
Bool GetUvAuto(U8 *flag);
Bool SetUvPara(float k,float b);
Bool GetUvPara(float *k,float *b);
Bool SetMyVersion(U16 Value);
Bool GetMyVersion(U16 *Value);
Bool FanOnOff(unsigned char flag);
//--------------------------------------------------------------------------
 typedef unsigned int (*__WriteBytes__)(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);
 typedef unsigned int (*__ReadBytes__)(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);

extern __WriteBytes__ WriteBytes;
extern __ReadBytes__  ReadBytes;

unsigned char GetStatus(void);

#define STATUS_IDLE		0
#define STATUS_BUSY		1
#define STATUS_ERROR	2
#define STATUS_SUCCESS	3

unsigned char GetSysStatus(void);

#define	MODE_NORMAL	  	0x0001
#define	MODE_STANBY		0x0002
#define MODE_POWER_ON  	0x0004
#define MODE_POWER_OFF 	0x0008

#ifdef __cplusplus
};
#endif


#endif